<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}" 
    :items="[
      [$title, url('products')],
      ['Tambah']
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Tambah {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('products/_store')}}" 
        method="post">
        <div class="card-body">
          <x-form.input 
            label="Nama Produk" name="title" 
            placeholder="Masukan nama produk" />
          <div class="row">
            <x-form.select
              div="col-md-4"
              label="Kategori" name="id_category_product"
              :collection="$categories" :option="['id', ['title']]" />
            <x-form.select
              div="col-md-4"
              label="Kemasan" name="id_package_product"
              :collection="$packages" :option="['id', ['title']]" />
            <x-form.select
              div="col-md-4"
              label="Satuan" name="id_unit_product"
              :collection="$units" :option="['id', ['title']]" />
          </div>
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>