<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('shopping')],
      [$item->id]
    ]" /> 

  <section class="content px-3">
    <div class="card">
      <div class="card-body">
        <div class="row mb-2">
          <x-form.input 
            div="col-md-5" value="{{$item->user?->name ?? '-'}}"
            label="Pembeli" readonly />
          <x-form.input 
            div="col-md-2" value="{{$item->purchase_dated}}"
            label="Tanggal Pembelian" readonly />
          <x-form.input 
            div="col-md-5" value="{{$item->vendor?->name_vendor ?? '-'}}"
            label="Vendor" readonly />
        </div>

        <h4 class="text-bold">PEMBAYARAN</h4>

        <div class="d-flex mb-2">
          <x-form.input 
            div="mr-2" value="{{ucwords($item->payment_method)}}"
            label="Tipe Pembayaran" readonly />
          <div class="mr-2">
            <p class="mb-2">&nbsp;</p>
            <a href="{{base_url($item->shopping_note)}}" class="btn btn-{{$item->shopping_note ? 'success' : 'danger'}}">
              <i class="fas fa-{{$item->shopping_note ? 'check' : 'times'}} mr-2"></i>      
              Nota Belanja  
            </a>
          </div>
          <div class="mr-2">
            <p class="mb-2">&nbsp;</p>
            <a href="{{base_url($item->proof_of_payment)}}" class="btn btn-{{$item->proof_of_payment ? 'success' : 'danger'}}">
              <i class="fas fa-{{$item->proof_of_payment ? 'check' : 'times'}} mr-2"></i>      
              Bukti Transfer 
            </a>
          </div>
        </div>

        <h4 class="text-bold">PRODUK</h4>

        <div class="mb-2">
          @foreach ($item->items as $e)
            <div class="row" style="border-bottom:1px solid #e9ecef">
              <x-form.input 
                div="col-md-6" value="{{$e->product['title']}}"
                label="Nama Produk" readonly />
              <x-form.input 
                div="col-md-3" value="{{$e->product['unit']}}"
                label="Satuan Unit" readonly />
              <x-form.input 
                div="col-md-3" value="{{$e->product['package']}}"
                label="Kemasan" readonly />

              <x-form.input 
                div="col-md-4" value="{{$e->qty}}"
                label="Jumlah" readonly />
              <x-form.input 
                div="col-md-4" value="{{number_format($e->price)}}"
                label="Harga Satuan" readonly />
              <x-form.input 
                div="col-md-4" value="{{number_format($e->subtotal)}}"
                label="Subtotal" readonly />
              <x-form.input 
                div="col-md-12" value="{{$e->description}}"
                label="Keterangan" readonly />
            </div>
          @endforeach
        </div>

      </div>
      <div class="card-footer">
        <a 
          onclick="return history.go(-1)" 
          class="btn btn-default" 
          id="_backButton">Kembali</a>
      </div>
    </div>
  </section>

</x-layout>