<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}" 
    :items="[
      [$title, url('subscriptions')],
      ['Tambah']
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Tambah {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('subscriptions/_store')}}" 
        method="post">
        <div class="card-body">
          <x-form.input 
            label="Judul" 
            name="title" 
            placeholder="Masukan Judul" />
          <div class="row">
            <x-form.input 
              label="Harga" div="col-md-6"
              name="price" type="number"
              placeholder="Masukan Harga" />
            <x-form.input 
              label="Durasi (BULAN)" div="col-md-6"
              name="duration"
              placeholder="Masukan Durasi" />
          </div>
          <div class="form-group">
            <label for="descriptionTextarea">Deskripsi</label>
            <textarea name="description" id="descriptionTextarea" class="form-control" rows="5" placeholder="Masukan Deskripsi"></textarea>
          </div>
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>