<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('top-up')],
      ['Bukti Transfer']
    ]" /> 

  <section class="content px-3">
    <div class="card">
      <form action="{{url('top-up/_proof-of-payment')}}" method="post" class="_form">
        <div class="card-body">
          <input name="id" value="{{$item->id}}" type="hidden" required />
          <div class="row">
            <x-form.input 
              div="col-md-3" readonly
              label="Nominal TopUp" value="{{number_format($item->nominal)}}" />
            <x-form.input 
              div="col-md-3" readonly
              label="Metode" value="{{$item->payment['title']}}" />
            <x-form.input 
              div="col-md-3" readonly
              label="TopUp Oleh" value="{{$item->admin->name}}" />
            <x-form.input 
              div="col-md-3" readonly
              label="Pada Tanggal" value="{{date('d/M/Y', strtotime($item->date))}}" />
          </div>
        
          <x-form.image 
            label="Bukti Transfer" name="file"
            id="file" required="off" />
        </div>
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script type="text/javascript" src="{{_asset('js/crud/post.js?ls=24231fef__')}}"></script>
  </x-slot>

</x-layout>