<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('users')],
      ['Edit']
    ]" /> 

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Edit Profile {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('users/_edit')}}"
        method="post">
        <div class="card-body row">
          <input type="hidden" name="id" value="{{$find->id}}" required>
          <x-form.input 
            div="col-md-4" 
            label="Nama" 
            name="name" 
            placeholder="Masukan nama" 
            value="{{$find->name}}" />
          <x-form.input 
            div="col-md-4" 
            type="email" name="email" 
            label="Email" 
            placeholder="Masukan email" 
            value="{{$find->email}}" />
          <x-form.select 
            div="col-md-4" 
            label="Otoritas Fitur" 
            name="authorities_id" 
            :collection="$authority" 
            :option="['id', ['title']]" 
            value="{{$find->authorities_id}}" />
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>

    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Edit Password {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('users/_password')}}" 
        method="post">
        <div class="card-body row">
          <input type="hidden" name="id" value="{{$find->id}}" required>
          <x-form.input 
            div="col-md-6" 
            label="Password Baru" 
            type="password" name="password" 
            placeholder="Password Baru" />
          <x-form.input 
            div="col-md-6" 
            label="Konfirmasi Password Baru" 
            type="password" name="password_confirmation" 
            placeholder="Konfirmasi Password Baru" />
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>