<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-search.vendor class="col-12 mb-3" />

      <x-partial.tab-role href="vendor">
        <thead>
          <tr>
            <th class="w-10px">No</th>
            <th>Vendor</th>
            <th>Kategori</th>
            <th>PIC</th>
            <th>Provinsi</th>
            <th>Kota / Kabupaten</th>
            <th>Kecamatan</th>
            <th>Dibuat Oleh</th>
            <th class="w-100px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($collection as $key => $item)
            <tr id="data-{{$item->id}}">
              <td class="numbering">{{no($key)}}</td>
              <td>{{$item->name_vendor ?? '-'}}</td>
              <td>{{$item->category?->title ?? '-'}}</td>
              <td>{{$item->pic ?? '-'}}</td>
              <td>{{$item->address?->province?->province_name ?? '-'}}</td>
              <td>{{$item->address?->city?->city_name ?? '-'}}</td>
              <td>{{$item->address?->subdistrict?->subdistrict_name ?? '-'}}</td>
              <td>{{$item->user?->name ?? '-'}}</td>
              <td id="action-{{$item->id}}">
                <a 
                  href="{{url('vendor/find/'.$item->id)}}" 
                  class="btn btn-warning btn-sm">
                  <i class="fas fa-link mr-2"></i>
                  Detail
                </a>
              </td>
            </tr>
          @endforeach
        </tbody>

        <x-slot name="extra">
          {{$collection->links('vendor.pagination.bootstrap-5')}}
        </x-slot>
      </x-partial.tab-role>
    </div>
  </section>

</x-layout>