<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('users')],
      ['Saldo']
    ]" /> 

  <section class="content px-3">
    <div class="card">
      <form 
        class="_form" method="post"
        action="{{url('ventures/_saldo')}}">
        <input type="hidden" name="user_id" value="{{$item->id}}" />
        <div class="card-body">
          <x-form.input 
            label="Saldo" name="saldo" class="inputRupiah"
            value="{{number_format($item->saldo, 0, '.', '.')}}" placeholder="Masukan Saldo" />
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button type="submit" class="btn btn-primary">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script type="text/javascript" src="{{_asset('js/rupiah.js')}}"></script>
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>