<?php

namespace App\Http\Controllers;

use App\Http\Requests\EmailLoginRequest;
use App\Http\Requests\OtpRequest;
use App\Http\Requests\OtpResendRequest;
use App\Http\Requests\RegisterRequest;
use App\Http\Requests\ResetRequest;
use App\Http\Resources\UserResource;
use App\Services\AuthService;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    //

    public function __construct(
        private AuthService $auth_service
    ) {
        $this->auth_service = $auth_service;
    }

    public function register(RegisterRequest $request)
    {
        return responseSuccess($this->auth_service->register($request));
    }

    public function forgotPassword(Request $request)
    {
        return responseSuccess($this->auth_service->forgotPassword($request->input('email')));
    }

    public function otpResetResend(OtpResendRequest $request)
    {
        $this->auth_service->otpResetResend($request);

        return responseSuccess();
    }

    public function otpVerifyReset(OtpRequest $request)
    {
        return responseSuccess($this->auth_service->verifyReset($request));
    }

    public function resetPassword(ResetRequest $request)
    {
        $this->auth_service->resetPassword($request);

        return responseSuccess();
    }

    public function otpVerifyRegist(OtpRequest $request)
    {
        return responseSuccess($this->auth_service->verifyRegits($request));
    }

    public function otpRegistResend(OtpResendRequest $request)
    {
        $this->auth_service->otpRegistResend($request);

        return responseSuccess();
    }

    public function emailLogin(EmailLoginRequest $request)
    {
        return responseSuccess($this->auth_service->emailLogin($request));
    }

    public function me()
    {
        return responseSuccess(['data' => new UserResource(auth()?->user())]);
    }
}
