<?php

namespace App\Http\Controllers;

use App\Http\Requests\WithdrawRequest;
use App\Http\Resources\WithdrawResource;
use App\Services\WithdrawService;
use Illuminate\Http\Request;

class WithdrawController extends Controller
{
    public function __construct(
        private WithdrawService $withdraw_service
    ) {
    }
    public function store(WithdrawRequest $request)
    {
        $this->withdraw_service->create($request);

        return responseSuccess();
    }

    public function detail($id)
    {
        return responseSuccess(['data' => new WithdrawResource($this->withdraw_service->find($id))]);
    }
}
