<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CustomerUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'id' => 'required',
            'name' => 'required',
            'pic' => 'required',
            'photo' => 'nullable',
            'phone_number' => 'required',
            'position' => 'required',
            'contract' => 'nullable',
            'id_province' => 'required',
            'id_city' => 'required',
            'id_subdistrict' => 'required',
            'village' => 'required',
            'postcode' => 'required',
            'address' => 'required',
            'rt' => 'required',
            'rw' => 'required',
            'latitude' => 'nullable',
            'longitude' => 'nullable',
        ];
    }
}
