<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class POUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'id' => 'required',
            'id_customer' => 'required',
            'purchase_date' => 'required',
            'transaction_type' => 'required',
            'payment_method' => 'required',
            'due_date' => 'required_if:transaction_type,==,tempo',
            'upload_po' => 'nullable',
            'upload_handover' => 'nullable',
            'upload_receipt' => 'nullable',
            'products' => 'required|array',
        ];
    }
}
