<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CustomerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $show['id']             = $this->id;
        $show['name']           = $this->name;
        $show['pic']            = $this->pic;
        $show['photo']          = ValidateIsFile($this->avatar);
        $show['phone_number']   = $this->phone_number;
        $show['position']       = $this->position;
        $show['contract']       = ValidateIsFile($this->contract);
        $show['id_province']    = $this->address?->id_province;
        $show['province']       = $this->address?->province?->province_name;
        $show['id_city']        = $this->address?->id_city;
        $show['city']           = $this->address?->city?->city_name;
        $show['id_subdistrict'] = $this->address?->id_subdistrict;
        $show['subdistrict']    = $this->address?->subdistrict?->subdistrict_name;
        $show['village']        = $this->address?->village;
        $show['postcode']       = $this->address?->postcode;
        $show['address']        = $this->address?->address;
        $show['rt']             = $this->address?->rt;
        $show['rw']             = $this->address?->rw;
        $show['latitude']       = $this->address?->latitude;
        $show['longitude']      = $this->address?->longitude;

        return $show;
    }
}
