<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PaymentMethodTypeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $show['id']     = $this->id;
        $show['name']   = $this->name;
        $show['code']   = $this->code;
        $show['file']   = ValidateIsFile($this->file);
        $show['items']  = PaymentMethodResource::collection($this->items);
        return $show;
    }
}
