<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ShoppingItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $show['id']         = $this->id;
        $show['id_product'] = $this->id_product;
        $show['product']    = $this->product;
        $show['price']      = $this->subtotal / $this->qty;
        $show['qty']        = $this->qty;
        $show['subtotal']   = $this->subtotal;
        $show['description'] = $this->description;

        return $show;
    }
}
