<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TransactionSubscriptionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $show['id']                 = $this->id;
        $show['invoice_id']         = $this->invoice_id;
        $show['id_user']            = $this->id_user;
        $show['subscription']       = $this->subscription;
        $show['total']              = $this->total;
        $show['subtotal']           = $this->subtotal;
        $show['status']             = $this->status;
        $show['payment_request']    = $this->payment_request;
        $show['payment_response']   = $this->payment_response;
        $show['payment_limit_at']   = translatedFormat($this->payment_limit_at, 'd/m/Y H:i');
        $show['created_at']         = translatedFormat($this->created_at, 'd/m/Y');
        
        return $show;
    }
}
