<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    
    public function toArray($request)
    {
        $now = Carbon::now()->toDateString();

        $_isSubs = $this->subs ? (($this->subs?->expired_at >= $now) ? true : false): false;

        $data['id']           = $this->id;
        $data['role']         = $this->role;
        $data['business']     = new UserBussinesResource($this?->business);
        $data['front_name']   = $this->front_name;
        $data['back_name']    = $this->back_name;
        $data['email']        = $this->email;
        $data['phone_number'] = $this->phone_number;
        $data['photo']        = ValidateIsFile($this->profile, 'image', 'user');
        $data['id_profession']= $this?->id_profession;
        $data['profession']   = $this?->profession?->title;
        $data['nik']          = $this->nik;
        $data['ktp']          = ValidateIsFile($this->ktp, 'document');
        $data['npwp']         = ValidateIsFile($this->npwp, 'document');
        $data['account']      = new UserAccountResource($this?->account);
        $data['is_verified']  = $_isSubs;
        $data['is_subs']      = $_isSubs; 

        return $data;
    }
}
