<?php

namespace App\Imports;

use App\Models\Product;
use App\Services\ProductService;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class ProductImport implements ToModel, WithStartRow, WithMultipleSheets
{
    public function startRow(): int
    {
        return 2;
    }
    public function sheets(): array
    {
        return [
            0 => $this,
        ];
    }
    public function model(array $row)
    {
        $user = auth()->user();
        $prod_service = new ProductService();

        $sku = $prod_service->get_sku($user);

        
        return new Product([
            'id_user' => $user->id,
            'title' => $row[0],
            'id_category_product' => $row[1],
            'id_unit_product' => $row[2],
            'id_package_product' => $row[3],
            'sku' => $sku,
        ]);
    }
}
