<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentMethod extends Model
{
    use HasFactory, SoftDeletes;

    public const NOMINAL = 'nominal';
    public const PERCENT = 'percent';

    public function paymentType()
    {
        return $this->belongsTo(PaymentMethodType::class, 'type');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['code'])) {
            $q->where('code', $request['code']);
        }

    }
}
