<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShoppingItem extends Model
{
    use HasFactory;

    protected $table = 'shopping_items';

    public function shopping()
    {
        return $this->belongsTo(Shopping::class, 'id_shopping');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'id_product');
    }

    protected $fillable = [
        'id_shopping', 'id_product', 'product', 'qty', 'subtotal', 'description', 'price'
    ];

    protected $casts = [
        'product' => 'json'
    ];

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['id_user'])) {
            $q->whereRelation('shopping', 'id_user', $request['id_user']);
        }

        if (!empty($request['id_product'])) {
            $q->where('id_product', $request['id_product']);
        }

        if (!empty($request['purchase_date'])) {
            $q->whereRelation('shopping', 'purchase_date', $request['purchase_date']);
        }
    }
}
