<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransactionSubscription extends Model
{
    use HasFactory;

    protected $casts = [
        'payment_request' => 'json',
        'payment_response' => 'json',
        'payment_webhook_response' => 'json'
    ];

    protected $fillable = [
        'invoice_id', 'id_user', 'id_subscription', 'total', 'fee', 'subtotal', 'status', 'payment_request',
        'payment_response', 'payment_webhook_response', 'payment_limit_at'
    ];

    protected $appends = [
        'nominal'
    ];

    public function subscription()
    {
        return $this->belongsTo(Subscription::class, 'id_subscription');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['payment_response'])) {
            $q->where('payment_response', $request['payment_response']);
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }

        if (!empty($request['status'])) {
            $q->where('status', $request['status']);
        }
    }

    public function getNominalAttribute()
    {
        return $this->subtotal;
    }
}
