<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserVaAccount extends Model
{
    use HasFactory;

    protected $fillable = [
        'id_user', 'va_id', 'va_bank_code', 'va_name', 'va_name', 'va_response', 'status'
    ];

    protected $casts = [
        'va_response' => 'json'
    ];

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['va_bank_code'])) {
            $q->where('va_bank_code', $request['va_bank_code']);
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }

        if (!empty($request['va_id'])) {
            $q->where('va_id', $request['va_id']);
        }
    }

    public const READY = 'ready';
    public const USED  = 'used';
}
