<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use App\Models\Category;

class CategoryExport implements FromCollection, WithTitle, WithCustomStartCell, ShouldAutoSize, WithEvents
{
    public $type;

    public function __construct($type)
    {
        $this->type = $type;
    }
    public function title(): string
    {
        return 'Kategori Produk';
    }
    public function startCell(): string
    {
        return 'A2';
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet;
                

                $sheet->setCellValue('A1', 'Kategori Id');
                $sheet->setCellValue('B1', 'Judul Kategori');


                $cols = array_keys($sheet->getDelegate()->getColumnDimensions());
                foreach ($cols as $col) {
                    $sheet->getDelegate()->getColumnDimension($col)->setAutoSize(true);
                }

                $styleArray = [
                    'font' => [
                        'bold' => true
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER
                    ]
                ];
            },
        ];
    }
    public function collection()
    {
        return Category::select('id', 'title')->whereType($this->type)->get();
    }
}
