<?php

namespace App\Http\Controllers;

use App\Http\Requests\PaymentPORequest;
use App\Services\POService;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ArController extends Controller
{
    public function __construct(
        private POService $po_service
    ) {
        $this->po_service = $po_service;
    }

    public function index(Request $request)
    {
        $type = $request->type ?? null;
        
        $start = Carbon::now()->toDateString();
        $end   = Carbon::now()->addDays(7)->toDateString();

        return responseSuccessPaginate($this->po_service->get_ar([
            'start_due_date' => $type != 'all' ? $start : null,
            'end_due_date'   => $type != 'all' ? $end : null
        ]), 200, [
            'start_date' =>  $type != 'all' ? translatedFormat($start, 'd/m/Y') : null,
            'end_date'   =>  $type != 'all' ? translatedFormat($end, 'd/m/Y') : null,
        ]);
    }

    public function payment(PaymentPORequest $request)
    {
        $this->po_service->payment($request);

        return responseSuccess();
    }
}
