<?php

namespace App\Http\Controllers;

use App\Http\Requests\PORequest;
use App\Http\Requests\POUpdateRequest;
use App\Http\Resources\POResource;
use App\Services\POService;
use Illuminate\Http\Request;

class POController extends Controller
{
    public function __construct(
        private POService $po_service
    ) {
        $this->po_service = $po_service;
    }

    public function create(PORequest $request)
    {
        $this->po_service->create($request);

        return responseSuccess();
    }

    public function update(POUpdateRequest $request)
    {
        $this->po_service->update($request);

        return responseSuccess();
    }

    public function index(Request $request)
    {
        return responseSuccessPaginate($this->po_service->list($request));
    }

    public function detail($id)
    {
        return responseSuccess(['data' => new POResource($this->po_service->find($id))]);
    }
    
    public function delete($id)
    {
        $this->po_service->delete($id);

        return responseSuccess();
    }

}
