<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VendorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'id_vendor_category' => 'required',
            'name_vendor' => 'required',
            'photo' => 'required',
            'pic' => 'required',
            // 'phone_number' => 'required|unique:vendor,phone_number',
            'phone_number' => 'required',
            'id_province' => 'required',
            'id_city' => 'required',
            'id_subdistrict' => 'required',
            'village' => 'required',
            'postcode' => 'required',
            'address' => 'required',
            'rt' => 'required',
            'rw' => 'required',
            'latitude' => 'nullable',
            'longitude' => 'nullable',
            'bank' => 'required',
            'branch' => 'required',
            'names' => 'required',
            'account_number' => 'required',
        ];
    }
}
