<?php

namespace App\Http\Resources;

use App\Models\CostItem;
use Illuminate\Http\Resources\Json\JsonResource;

class CostResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $show['id']                      = $this->id;
        $show['purchase_date']           = translatedFormat($this->purchase_date, 'd/m/Y');
        $show['payment_method']          = $this->payment_method;
        $show['upload_nota']             = ValidateIsFile($this->upload_nota);
        $show['upload_proof_of_payment'] = ValidateIsFile($this->upload_proof_of_payment);
        $show['costs']                   = CostItemResource::collection(CostItem::where('id_op_pengeluaran', $this->id)->get());

        return $show;
    }
}
