<?php

namespace App\Http\Resources;

use App\Models\POItem;
use Illuminate\Http\Resources\Json\JsonResource;

class POResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $show['id']                 = $this->id;
        $show['id_customer']        = $this->id_customer;
        $show['customer']           = $this->customer?->name;
        $show['purchase_date']      = translatedFormat($this->purchase_date, 'd/m/Y');
        $show['transaction_type']   = $this->transaction_type;
        $show['payment_method']     = $this->payment_method;
        $show['due_date']           = $this->due_date <> '' ? translatedFormat($this->due_date, 'd/m/Y') : null;
        $show['total_payment']      = $this->items?->sum('subtotal');
        $show['payment_date']       = $this->payment_date <> '' ? translatedFormat($this->payment_date, 'd/m/Y') : null;
        $show['upload_po']          = ValidateIsFile($this->upload_po);
        $show['upload_handover']    = ValidateIsFile($this->upload_handover);
        $show['upload_receipt']     = ValidateIsFile($this->upload_receipt);
        $show['products']           = ShoppingItemResource::collection(POItem::where('id_po', $this->id)->get());

        return $show;
    }
}
