<?php

namespace App\Http\Resources;

use App\Models\ShoppingItem;
use Illuminate\Http\Resources\Json\JsonResource;

class ShoppingResource extends JsonResource
{
    
    public function toArray($request)
    {
        $show['id']                 = $this->id;
        $show['id_vendor']          = $this->id_vendor;
        $show['vendor']             = $this->vendor?->name_vendor;
        $show['purchase_date']      = $this->purchase_date;
        $show['payment_method']     = $this->payment_method;
        $show['transfer_photo']     = ValidateIsFile($this->proof_of_payment);
        $show['payment_photo']      = ValidateIsFile($this->shopping_note);
        $show['products']           = ShoppingItemResource::collection(ShoppingItem::where('id_shopping', $this->id)->get());

        return $show;
    }
}
