<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserBussinesResource extends JsonResource
{
    public function toArray($request)
    {
        $data['id']             = $this->id;
        $data['name_bussines']  = $this->name_bussines;
        $data['id_province']    = $this->id_province;
        $data['province']       = $this->province?->province_name;
        $data['id_city']        = $this->id_city;
        $data['city']           = $this->city?->city_name;
        $data['id_subdistrict'] = $this->id_subdistrict;
        $data['subdistrict']    = $this->subdistrict?->subdistrict_name;
        $data['village']        = $this->village;
        $data['postcode']       = $this->postcode;
        $data['address']        = $this->address;
        $data['rt']             = $this->rt;
        $data['rw']             = $this->rw;
        $data['photo']          = ValidateIsFile($this->profile_bussines, 'image', 'user');
        $data['latitude']       = $this->latitude;
        $data['longitude']      = $this->longitude;
        $data['akta']           = ValidateIsFile($this->akta, 'document');
        $data['nib']            = ValidateIsFile($this->nib, 'document');
        $data['sk_kemenkum']    = ValidateIsFile($this->sk_kemenkum, 'document');
        $data['npwp']           = ValidateIsFile($this->npwp, 'document');

        return $data;
    }
}
