<?php

namespace App\Mail;

use App\Models\UserOtp;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NotifyEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(
        private $otp,
        $type
    ) {
        //
        $this->otp = $otp;
        $this->type = $type;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        switch ($this->type) {
            case UserOtp::VERIFY:
                $subject = 'Kode OTP Registrasi';
                break;

            case UserOtp::RESET:
                $subject = 'Kode OTP Reset Password';
                break;

            default:
                $subject = '-';
                break;
        }

        return $this
            ->subject($subject)
            ->view('email.register', [
                'otp' => $this->otp
            ]);
    }
}
