<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PO extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'po';

    protected $fillable = [
        'id', 'id_customer', 'id_user', 'purchase_date', 'transaction_type', 'payment_method',
        'due_date', 'payment_date', 'upload_po', 'upload_handover', 'upload_receipt', 'upload_payment'
    ];

    protected $appends = [
        'nominal'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'id_customer')->withTrashed();
    }

    public function items()
    {
        return $this->hasMany(POItem::class, 'id_po', 'id');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }

        if (!empty($request['due_date'])) {
            $q->where('due_date', $request['due_date']);
        }

        if (!empty($request['payment_date'])) {
            $q->where('payment_date', $request['payment_date']);
        }

        if (!empty($request['is_payment']) && $request['is_payment'] == 'true') {
            $q->where('payment_date', null);
        }

        if (!empty($request['transaction_type'])) {
            $q->where('transaction_type', $request['transaction_type']);
        }

        if (!empty($request['start_due_date']) && !empty($request['end_due_date'])) {
            $q->whereBetween('due_date', [$request['start_due_date'], $request['end_due_date']]);
        }
    }

    public function getNominalAttribute()
    {
        return $this->items->sum('subtotal');
    }

    
}
