<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentMethodType extends Model
{
    use HasFactory, SoftDeletes;

    public const BANK_TRANSFER = 'transfer_va';
    public const EMONEY        = 'emoney';
    public const CSTORE        = 'cstore';

    public function items()
    {
        return $this->hasMany(PaymentMethod::class, 'type', 'id');
    }
}
