<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shopping extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'shopping';

    protected $fillable = [
        'id', 'id_vendor', 'id_user', 'purchase_date', 'payment_method', 'proof_of_payment',
        'shopping_note'
    ];

    protected $primaryKey = 'id';

    public $incrementing = false;

    protected $keyType = 'string';

    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'id_vendor')->withTrashed();
    }

    public function items()
    {
        return $this->hasMany(ShoppingItem::class, 'id_shopping', 'id');
    }

    public function scopeWithParameters($q, $request)
    {
        if (!empty($request['q'])) {
            
        }

        if (!empty($request['id_user'])) {
            $q->where('id_user', $request['id_user']);
        }
    }
}
