<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'code',
        'front_name',
        'back_name',
        'nik',
        'email',
        'phone_number',
        'id_profession',
        'profile',
        'ktp',
        'npwp',
        'active',
        'verified_at',
        'password',
        'skema'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_darkmode' => 'boolean'
    ];

    public $appends = [
        'is_verified'
    ];


    public function business()
    {
        return $this->belongsTo(UserBussines::class, 'id', 'id');
    }

    public function account()
    {
        return $this->belongsTo(UserAccount::class, 'id', 'id');
    }

    public function profession()
    {
        return $this->belongsTo(Profession::class, 'id_profession')->withTrashed();
    }

    public function approved()
    {
        return $this->belongsTo(UserApproved::class, 'id');
    }

    public function saldo()
    {
        return $this->belongsTo(UserSaldo::class, 'id');
    }

    public function subs()
    {
        return $this->hasOne(UserSubscription::class, 'user_id')->orderby('expired_at', 'desc');
    }

    public function getIsVerifiedAttribute()
    {
        return ($this->approved?->id_admin <> '' && $this?->approved?->status <> 'ya') ? true : false;
    }

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}
