<?php

namespace App\Services;

use App\Models\{Withdraw};
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Exceptions\ErrorHandlingException;

class WithdrawService
{
    public function __construct(
        private NotifService $notif_service,
    ) {
    }
    public function find($id)
    {
        return Withdraw::find($id);
    }

    public function create($request)
    {
        DB::beginTransaction();

        $user = auth()->user();

        $with = Withdraw::create([
            'id_user'   => $user->id,
            'nominal'   => $request->nominal,
            'account'   => $user->account,
            'status'    => 'pending'
        ]);

        $this->notif_service->store("withdraw", "Status: ". $with->status, null, 'all', $with);
        
        DB::commit();

        return true;
    }

    
    
}
