<?php

namespace App\Services\Xendit;

use App\Models\AdminVaAccount;
use App\Models\Notification;
use App\Models\TopUp;
use App\Models\TransactionSubscription;
use App\Models\UserAccount;
use App\Models\UserVaAccount;
use App\Services\SubscriptionService;
use Illuminate\Http\Request;

class XenditNotifService
{
    public function __construct(
        private SubscriptionService $subs_service,
    ) {
    }
    public function virtualAccountPaid(Request $request)
    {
        $external_id = $request->input('external_id');
        $amount      = $request->input('amount');

        $va_id      = $request->input('callback_virtual_account_id');

        $_checkExternal = explode("_", $external_id)['0'];

        if ($_checkExternal == 'SUBS') {

            $transaction = TransactionSubscription::where('payment_response->external_id', $external_id)->where('subtotal', $amount)->orderby('id', 'desc')->first();

            if ($transaction) {
                $transaction->update([
                    'status' => 'done',
                    'payment_webhook_response' => $request->all()
                ]);    

                $user_va = UserVaAccount::withParameters(['va_id' => $va_id])->first();

                if ($user_va) {
                    $user_va->update([
                        'status' => UserVaAccount::READY
                    ]);
                }

                $this->subs_service->store([
                    'id_subscription' => $transaction->id_subscription,
                    'id_user'         => $transaction->id_user,
                    'total'           => $transaction->total,
                ]);

                $notif = Notification::where('type', 'subscribe')->where('key->invoice_id', $transaction->invoice_id)->first();

                if ($notif) {
                    $notif->update([
                        'description' => 'Status: Lunas'
                    ]);
                }
            }
        } else if ($_checkExternal == 'TOPUP') {
            $topup = TopUp::where('response->external_id', $external_id)->where('nominal', $amount)->first();
            if ($topup) {
                // dd('aswp_subscription');
                $topup->update([
                    'response' => $request->all()
                ]);  
                
                $admin_va = AdminVaAccount::withParameters(['va_id' => $va_id])->first();

                if ($admin_va) {
                    // dd('aswp_subscription');
                    $admin_va->update([
                        'status' => AdminVaAccount::READY,
                        'va_response' => $request->all()
                    ]);
                }
            }
        }
    }

    public function csStorePaid(Request $request)
    {
        $external_id = $request->input('external_id');
        $amount      = $request->input('amount');

        $va_id      = $request->input('fixed_payment_code_id');

        $_checkExternal = explode("_", $external_id)['0'];

        if ($_checkExternal == 'SUBS') {

            $transaction = TransactionSubscription::where('payment_response->external_id', $external_id)->where('subtotal', $amount)->first();

            if ($transaction) {
                $transaction->update([
                    'status' => 'done',
                    'payment_webhook_response' => $request->all()
                ]);    

                $user_va = UserVaAccount::withParameters(['va_id' => $va_id])->first();

                if ($user_va) {
                    $user_va->update([
                        'status' => UserVaAccount::READY
                    ]);
                }

                $this->subs_service->store([
                    'id_subscription' => $transaction->id_subscription,
                    'id_user'         => $transaction->id_user,
                    'total'           => $transaction->total,
                ]);
            }
        } else if ($_checkExternal == 'TOPUP') {
            $topup = TopUp::where('response->external_id', $external_id)->where('nominal', $amount)->first();

            if ($topup) {
                $topup->update([
                    'response' => $request->all()
                ]);  
                
                $admin_va = AdminVaAccount::withParameters(['va_id' => $va_id])->first();

                if ($admin_va) {
                    $admin_va->update([
                        'status' => AdminVaAccount::READY,
                        'va_response' => $request->all()
                    ]);
                }
            }
        }
    }


}
