<?php

namespace App\Services\Xendit;

use App\Constants\EWalletConstant;
use App\Models\PaymentMethodType;
use Xendit\Xendit;

class XenditService
{
    public function __construct(
        private XenditVaService $xendit_va_service,
        private XenditCstoreService $xendit_cstore_service,
        private XenditEWalletService $xendit_ewallet_service

    ) {
        Xendit::setApiKey(config('xendit.key'));
    } 

    public function sendXendit(string $payment_method_type, string $payment_method, string $id_user, int $nominal)
    {
        switch ($payment_method_type) {
            case PaymentMethodType::BANK_TRANSFER:
                $result_json = $this->virtualAccount($payment_method, $id_user, $nominal);
                break;
            case PaymentMethodType::CSTORE:
                $result_json = $this->cstore($payment_method, $id_user, $nominal);
                break;
            case PaymentMethodType::EMONEY:
                $result_json = $this->ewallet($payment_method, $id_user, $nominal);
                break;
            default:
                $result_json = [];
                break;
        }

        // dd($result_json);

        return $result_json;
    }

    public function virtualAccount(string $bank_code, string $id_user, int $total)
    {
        $user_va = $this->xendit_va_service->findAccount($bank_code,  $id_user, $total);

        if (!$user_va) {
            return $this->xendit_va_service->createAccount($bank_code, $id_user, $total)['va_response'];
        }

        if (!$user_va['new'] && $user_va['e']['va_response']['is_closed']) {
            $this->xendit_va_service->updateExceptedAmount($user_va['e']['va_id'], $total)['va_response'];
        }
        
        return $this->xendit_va_service->setUsed($bank_code, $id_user)['va_response'];
    }

    public function cstore(string $type, string $id_user, int $total)
    {
        
        $user_va = $this->xendit_cstore_service->findAccount($type,  $id_user, $total);
        
        if (!$user_va['new'] && $user_va['e']['va_response']['is_closed']) {
            $update_va = $this->xendit_cstore_service->updateExceptedAmount($user_va['e']['va_id'], $total);
        }

        return $this->xendit_cstore_service->setUsed($type, $id_user)['va_response'];
    }

    public function ewallet(string $type, string $id_user, int $total, ?array $data = [])
    {
        switch ($type) {
            case EWalletConstant::OVO:
                return $this->xendit_ewallet_service->ovo($total);
                break;
            case EWalletConstant::DANA:
                return $this->xendit_ewallet_service->dana($total);
                break;
            case EWalletConstant::LINK_AJA:
                return $this->xendit_ewallet_service->linkAja($total, $data);
                break;
            case EWalletConstant::SHOPEE_PAY:
                return $this->xendit_ewallet_service->shoppe($total);
                break;
            default:
                return [];
                break;
        }
    }
}
