<?php

namespace App\Services\Xendit;

use App\Exceptions\CatchErrorException;
use App\Exceptions\ErrorHandlingException;
use App\Models\UserVaAccount;
use App\Repositories\Interfaces\UserVaAccountRepositoryInterface;
use Illuminate\Support\Facades\DB;
use Xendit\Exceptions\ApiException;
use Xendit\VirtualAccounts;
use Xendit\Xendit;

class XenditVaService
{
    public function __construct(
        private UserVaAccount $user_va_account
    ) {
        Xendit::setApiKey(config('xendit.key'));
    }

    public function getVaBank()
    {
        return VirtualAccounts::getVABanks();
    }

    public function findAccount(string $bank_code, string $id_user, int $total)
    {
        $array = ['va_bank_code' => strtoupper($bank_code), 'id_user' => $id_user];

        $user_va = $this->user_va_account->withParameters($array)->first();
        if (!$user_va) {
            return [
                'new' => true,
                'e' => $this->createAccount($bank_code, $id_user, $total)
            ];
        }

        $check_va_account = $this->checkAccount($user_va->va_id);
        if (is_null($check_va_account) or count($check_va_account) == 0) {
            return  [
                'new' => true,
                'e' => $this->createAccount($bank_code, $id_user, $total)
            ];
        }

        return  [
            'new' => false,
            'e' => $user_va
        ];
    }

    public function updateExceptedAmount(string $va_id, int $amount)
    {
        $field = [
            'expected_amount' => $amount,
            "expiration_date" => expiredDate()
        ];

        $response = VirtualAccounts::update($va_id, $field);

        try {

            $user_va = $this->user_va_account->withParameters(['va_id' => $va_id])->first();
            $user_va->update([
                "va_response" => $response
            ]);

            DB::commit();
            return $user_va;
            //return
        } catch (\Throwable $th) {
            DB::rollBack();
            throw new ErrorHandlingException(500, $th->getMessage());
        }
    }


    public function checkAccount(string $va_id): ?array
    {
        try {
            return VirtualAccounts::retrieve($va_id);
        } catch (\Throwable $th) {
            return null;
        }
    }

    public function createAccount(string $bank_code, string $id_user, int $total)
    {
        DB::beginTransaction();

        $name = auth()->user()->front_name." ".auth()->user()->back_name;

        $bank_store = strtoupper($bank_code);

        $params = [
            "external_id" => "SUBS_VA_" . $bank_store . "_" . rand(11111111, 99999999),
            "bank_code" => $bank_store,
            "name" => $name,
            "is_closed" => true,
            "expected_amount" => $total,
            "expiration_date" => expiredDate()
        ];
        
        // dd(expiredDate());
        // dd($params);

        $response = VirtualAccounts::create($params);

        try {

            $user_va = UserVaAccount::create([
                'id_user'      => $id_user,
                'va_id'        => $response['id'],
                'va_bank_code' => $response['bank_code'],
                'va_name'      => $name,
                'va_response'  => $response,
            ]);

            DB::commit();

            return $user_va;
            //return
        } catch (\Throwable $th) {
            DB::rollBack();
            throw new ErrorHandlingException(500, $th->getMessage());
        }
    }

    public function setUsed(string $bank_code, string $user_id)
    {
        try {
            $array = ['va_bank_code' => strtoupper($bank_code), 'id_user' => $user_id, 'status' => UserVaAccount::READY];

            $user_va = $this->user_va_account->withParameters($array)->first();
            
            $user_va->update([
               "status" => UserVaAccount::USED
            ]);

            DB::commit();
            return $user_va;
        } catch (\Throwable $th) {
            DB::rollBack();
            throw new ErrorHandlingException(500, $th->getMessage());
        }
    }



}
