<?php

use App\Http\Controllers\ArController;
use App\Http\Controllers\AreaController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BankController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CooperationStatusController;
use App\Http\Controllers\CostController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\POController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfessionController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\ShoppingController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\WithdrawController;
use App\Http\Controllers\XenditController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['controller' => AuthController::class], function () {

    Route::post('register', 'register');
    Route::post('forgot', 'forgotPassword');
    Route::post('reset', 'resetPassword');
    Route::group(['prefix' => 'otp'], function () {

        Route::group(['prefix' => 'resend'], function () {

            Route::post('regist', 'otpRegistResend');
            Route::post('reset', 'otpResetResend');
        });

        Route::group(['prefix' => 'verify'], function () {

            Route::post('regist', 'otpVerifyRegist');
            Route::post('reset', 'otpVerifyReset');
        });
    });

    Route::group(['prefix' => 'login'], function () {

        Route::post('email', 'emailLogin');
    });

    Route::group(['prefix' => 'user', 'controller' => UserController::class, 'middleware' => 'check-token'], function () {

        Route::post('/update', 'update');
    });

    Route::group(['prefix' => 'home', 'controller' => HomeController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/inventory', 'inventory');
        Route::get('/sale', 'sale');
        Route::get('/opex', 'opex');
    });

    Route::get('me', 'me')->middleware('check-token');

    Route::get('profession', [ProfessionController::class, 'index']);

    Route::get('province', [AreaController::class, 'province']);

    Route::get('city/{province_id}', [AreaController::class, 'city']);

    Route::get('subdistrict/{city_id}', [AreaController::class, 'subdistrict']);

    Route::get('bank', [BankController::class, 'index']);

    Route::get('category', [CategoryController::class, 'index']);

    Route::get('unit', [UnitController::class, 'index']);

    Route::get('package', [PackageController::class, 'index']);

    Route::get('payment', [PaymentController::class, 'index']);

    Route::get('product/export-template', [ProductController::class, 'exportTemplateProduct']);

    Route::get('check-transaction-subscription', [SubscriptionController::class, 'check_transaction']);

    Route::group(['prefix' => 'xendit', 'controller' => XenditController::class], function () {
        Route::post('/notification/virtual-account', 'webhookVa');
        Route::post('/notification/cstore', 'webhookCstore');
    });

    Route::get('product-po', [ProductController::class, 'indexPO', 'middleware' => 'check-token']);

    Route::group(['prefix' => 'product', 'controller' => ProductController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::post('/', 'create');
        Route::post('/update', 'update');
        Route::delete('/{id}', 'delete');
        Route::post('/import-product', 'importProduct');
    });

    Route::group(['prefix' => 'vendor', 'controller' => VendorController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/{id}', 'detail');
        Route::post('/', 'create');
        Route::post('/update', 'update');
        Route::delete('/{id}', 'delete');
    });

    Route::group(['prefix' => 'shopping', 'controller' => ShoppingController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/{id}', 'detail');
        Route::post('/', 'create');
        Route::post('/update', 'update');
        Route::delete('/{id}', 'delete');
        Route::get('/history/stock', 'stock');
    });

    Route::group(['prefix' => 'customer', 'controller' => CustomerController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/{id}', 'detail');
        Route::post('/', 'create');
        Route::post('/update', 'update');
        Route::delete('/{id}', 'delete');
    });

    Route::group(['prefix' => 'po', 'controller' => POController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/{id}', 'detail');
        Route::post('/', 'create');
        Route::post('/update', 'update');
        Route::delete('/{id}', 'delete');
    });

    Route::group(['prefix' => 'ar', 'controller' => ArController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::post('/payment', 'payment');
    });

    Route::group(['prefix' => 'sale', 'controller' => SaleController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
    });

    Route::group(['prefix' => 'cost', 'controller' => CostController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/{id}', 'detail');
        Route::post('/', 'create');
        Route::post('/update', 'update');
        Route::delete('/{id}', 'delete');
        Route::get('/history/month', 'historyMonth');
    });

    Route::group(['prefix' => 'notification', 'controller' => NotificationController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/read/{id}', 'read');
    });

    Route::get('cooperation-status', [CooperationStatusController::class, 'index', 'middleware' => 'check-token']);

    Route::group(['prefix' => 'subscription', 'controller' => SubscriptionController::class, 'middleware' => 'check-token'], function () {

        Route::get('/', 'index');
        Route::get('/{id}', 'detail');
        Route::post('/checkout', 'checkout');
        Route::get('/checkout/{id}', 'detail_transaction');
    });

    Route::group(['prefix' => 'withdraw', 'controller' => WithdrawController::class, 'middleware' => 'check-token'], function () {

        Route::post('/', 'store');
        Route::get('/{id}', 'detail');
    });
    
});

