$(document).ready(function() {
  $('input').each(function(i, obj) {
    var data = $(this).val().trim()
    $(this).val(data)
  });
});

$.ajaxSetup({
  headers: {
    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
  }
});
const features = $(`.nav .nav-treeview`).map(function(e){
  if($(this).children('li').length < 1){
    $(this).parent().remove()
  }
});

var currentUrl = window.location.href
var currentParams = new URL(currentUrl);
if (currentParams.searchParams.get("_activity") === 'search') {
  $(`.card.card-info.collapsed-card > div > .card-tools > .btn.btn-tool`).click()
}

function readURL(input, element){
  if(input.files && input.files[0]){
    $(`#${element[1]}`).remove();
    const reader = new FileReader();
    reader.onload = function(e){
      $(`#${element[0]}`).after(`<div id="${element[1]}"><img src="${e.target.result}" style="margin-top: 10px;width:200px;height:auto"></div>`);
    }
    reader.readAsDataURL(input.files[0])
  }
}

$(`#file`).change(function(){
  readURL(this, ['file', 'preview'])
})

$(`#file2`).change(function(){
  readURL(this, ['file2', 'preview2'])
})

$(`#file3`).change(function(){
  readURL(this, ['file3', 'preview3'])
})

$(`#file4`).change(function(){
  readURL(this, ['file4', 'preview4'])
})

$(`#file5`).change(function(){
  readURL(this, ['file5', 'preview4'])
})

$(`#file6`).change(function(){
  readURL(this, ['file6', 'preview4'])
})

$(`#file7`).change(function(){
  readURL(this, ['file7', 'preview4'])
})

$(`#file8`).change(function(){
  readURL(this, ['file8', 'preview4'])
})

$(`#file9`).change(function(){
  readURL(this, ['file9', 'preview4'])
})

$(`#file10`).change(function(){
  readURL(this, ['file10', 'preview4'])
})

const errorCustom = (e) => {
  try {
    var _error = JSON.parse(e.responseText)
    if (_error.message == 'CSRF token mismatch.') {
      setTimeout(() => {
        location.reload();
      }, 2900);
      return 'Token kadaluwarsa, halaman akan dimuat ulang secara otomatis dalam 3 detik / anda bisa merefresh halaman secara langsung'
    } else if(_error.message == '' && e.statusText == 'Not Found'){
      return 'Alamat URL / Fungsi tidak ditemukan!'
    }
    return _error.message;
  } catch (error) {
    var ex = e.responseText
    ex = ex.replace(`{"`, `#JSON_SEPARATOR#{"`)
    ex = ex.split(`#JSON_SEPARATOR#`)
    var _error = JSON.parse(ex[1])
    return _error.message;
  }
};

var freezeClic = false

var disableClick = (data) => {
  freezeClic = data;
};

document.addEventListener("click", freezeClicFn, true);
function freezeClicFn(e) {
  if (freezeClic) {
    e.stopPropagation();
    e.preventDefault();
  }
}

const swalWaiting = () => {

  disableClick(1)

  Swal.fire({
    text: 'Tunggu proses selesai',
    icon: 'question',
    iconHtml: '<i class="fas fa-hourglass-half"></i>',
    showCancelButton: false,
    showConfirmButton: false,
  });
};

const swalLauncher = (e) => {
  Swal.fire({
    title: (e.success == true) ? 'Berhasil!' : 'Gagal!',
    text: e.message,
    icon: (e.success == true) ? 'success' : 'error',
    showConfirmButton: false,
    timer: (e.success == true) ? 1500 : 3000,
  });
};
