const ignoreConfirmation = document.currentScript.getAttribute('ignoreConfirmation');

var $editors = $(".ckeditor");
if ($editors.length) {
  for (instance in ClassicEditor.instances) 
  {
    ClassicEditor.instances[instance].updateElement();
  }
} 

$('._form').submit(function(e){
  e.preventDefault()

  const run = (e) => {
    swalWaiting()

    var formData = new FormData(this)
    // formData.append("key", "value")
  
    $.ajax({
      url : this.action,
      type : "POST",
      data : formData,
      processData : false,
      contentType : false,
      cache : false,
      success: function (e) {
        Swal.close()
        disableClick(false)
        swalLauncher(e)
        if(e.log){
          console.log(e.log);
        }
        if(e.url){
          setTimeout(() => {
            if (e.url == 'back') {
              return window.history.go(-1);
            } else if (e.url == 'reload') {
              return location.reload();
            }
            window.location.replace(e.url)
          }, 1500);
        }
      },
      error: function(e) {
        Swal.close()
        disableClick(false)
        var err = errorCustom(e);
        swalLauncher({message : err})
      }
    });
    return false;
  };

  if(ignoreConfirmation){
    run(e)
  } else {
    Swal.fire({
      title: $(this).data('swal-title') ?? 'Apakah data anda sudah benar?',
      text: $(this).data('swal-text') ?? "Pastikan data yang anda masukan sudah benar untuk di simpan",
      showCancelButton: true,
      confirmButtonColor: $(this).data('swal-confirm-btn-color') ?? '#3085d6',
      cancelButtonColor: $(this).data('swal-cancel-btn-color') ?? '#d33',
      confirmButtonText: $(this).data('swal-confirm-btn-text') ?? 'Ya, data sudah benar',
      cancelButtonText: $(this).data('swal-cancel-btn-text') ?? 'Tidak, saya akan cek lagi'
    }).then((result) => {
      if (result.isConfirmed) {
        run(e)
      }
    })
  }
  
})
