$(document).ready(function() {
  $(`#nominal_penarikan`).on('input', function() {
    var raw = $(this).val()
    var nominal = Number(raw.replace(/[^,\d]/g, ""))

    var feePercent = $('#fee_percent')

    if (feePercent.length > 0) {
      var result = nominal * (Number(feePercent.val()) / 100)
      $('#fee_penarikan').val(formatRupiah(result.toString()))
    }

    var feeRaw = $('#fee_penarikan').val()
    var fee = Number(feeRaw.replace(/[^,\d]/g, ""))

    var total = fee + nominal

    $('#total_penarikan').val(formatRupiah(total.toString()))
  })

  $(`#sent-otp`).on('click', function(e) {
    $(`#sent-otp`).hide()
    $(`#loading-otp`).show()
    $.ajax({
      url: `${prefixURL}/revenue/subscription/otp`,
      type: 'POST',
      success: function (e) {
        $(`#sent-otp`).show()
        $(`#loading-otp`).hide()
        Swal.fire({
          title: 'Berhasil!',
          text: 'Kode OTP berhasil dikirim!',
          icon: 'success',
          timer: 1500,
        });
      },
      error: function (e) {
        $(`#sent-otp`).show()
        $(`#loading-otp`).hide()
        Swal.fire({
          title: 'Gagal!',
          text: e.message,
          icon: 'failed'
        });
      }
    });
  })
});