<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\PurchaseOrderRepository;

class ArController extends Controller
{
    public function __construct(
        private PurchaseOrderRepository $repository,
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Pembayaran Terdekat',
            'collection' => $this->repository->ar(array_merge([
                'transaction_type' => 'tempo',
                'ar' => true
            ], $req->all()))
        ];
        return view('ar.index', $params);
    }
}
