<?php

namespace App\Http\Controllers;

use App\Models\Configuration;
use App\Models\User;  
use Illuminate\Http\Request;
use InvalidArgumentException;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
  function index(){
    return view('auth.login', [
      'configuration' => Configuration::first()
    ]);
  }

  function run(Request $req){
    try {
      $get = User::where('email', $req->email)->first();
      if (!$get || !Hash::check($req->password, $get->password)) {
        throw new InvalidArgumentException('Ups, email atau password yang anda masukan salah', 404);
      }
      if($get->active != 'yes'){
        throw new InvalidArgumentException('Ups, akun anda di nonaktifkan', 422);
      }
      Auth::guard('web')->login($get);
      return [
        'code' => 200,
        'success' => true,
        'url' => route('dashboard')
      ];
    } catch (\Throwable $th) {
      return errors($th);
    }
  }

  function logout(Request $request){
    Auth::guard('web')->logout();
    $request->session()->invalidate();
    $request->session()->regenerateToken();
    return redirect('/');
  }
}
