<?php

namespace App\Http\Controllers;

use App\Models\Authority;
use App\Services\AuthorityService;
use Illuminate\Http\Request;

class AuthorityController extends Controller
{

  public function __construct(
    private AuthorityService $service
  ) {
  
  }

  function index(){
    return view('authority.index', [
      'collection' => Authority::getData()
    ]);
  }

  function add(){
    return view('authority.add');
  }

  function edit($id){
    $find = Authority::findData($id);

    if (!$find) {
      return abort(404);
    }

    return view('authority.edit', $find);
  }

  function create(Request $req){
    return $this->service->container($req, 'store');
  }

  function delete(Request $req){
    return $this->service->container($req, 'delete');
  }

  function update(Request $req){
    return $this->service->container($req, 'update');
  }
}
