<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\BankService;
use App\Repositories\BankRepository;

class BankController extends Controller
{
  public function __construct(
    private BankRepository $repository,
    private BankService $service
  ) {
  
  }
  
  function index(Request $req){
    $params = [
      'title' => 'Bank',
      'collection' => $this->repository->get($req->all())
    ];
    return view('bank.index', $params);
  }
  
  function add(){
    $params = [
      'title' => 'Bank'
    ];
    return view('bank.add', $params);
  }
  
  function edit($id){
    $find = $this->repository->find($id);

    if (!$find) {
        return abort(404);
    }

    $params = [
        'title' => 'Bank',
        'item' => $find,
    ];
    return view('bank.edit', $params);
  }
  
  function store(Request $req){
    return $this->service->container($req, 'store');
  }
  
  function update(Request $req){
    return $this->service->container($req, 'update');
  }
  
  function delete(Request $req){
    return $this->service->container($req, 'delete');
  }
}
