<?php

namespace App\Http\Controllers;

use App\Repositories\BranchRepository;
use App\Services\BranchService;
use Illuminate\Http\Request;

class BranchController extends Controller
{
    public function __construct(
        private BranchRepository $repository,
        private BranchService $service
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Cabang',
            'collection' => $this->repository->get($req->all())
        ];
        return view('branch.index', $params);
    }
    
    function add(){
        $params = [
            'title' => 'Cabang'
        ];
        return view('branch.add', $params);
    }
    
    function edit($id){
        $find = $this->repository->find($id);

        if (!$find) {
            return abort(404);
        }

        $params = [
            'title' => 'Cabang',
            'item' => $find,
        ];
        return view('branch.edit', $params);
    }
    
    function store(Request $req){
        return $this->service->container($req, 'store');
    }
    
    function update(Request $req){
        return $this->service->container($req, 'update');
    }
    
    function delete(Request $req){
        return $this->service->container($req, 'delete');
    }
}
