<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Repositories\PaymentMethodRepository;
use App\Services\ConfigurationService;

class ConfigurationController extends Controller
{

  public function __construct(
    private ConfigurationService $service,
    private PaymentMethodRepository $paymentMethod,
  ) {
  
  }

  function index(Request $req){
    $params = [
      'title' => 'Konfigurasi',
      'item' => Configuration::first(),
      'banks' => $this->paymentMethod->clean([
        'type' => 4
      ])
    ];
    return view('configuration.index', $params);
  }

  function store(Request $req){
    return $this->service->store($req);
  }
}
