<?php

namespace App\Http\Controllers;

use App\Models\Activity;
use InvalidArgumentException;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
  use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

  public function upload($img, $folder)
  {
    try {
      $folder_ext = explode('/', $folder);
      $path = 'storage/upload/'.$folder;
      if (!file_exists($path)) {
        mkdir($path, 0755, true);
      }
      $extension = $img->getClientOriginalExtension();
      $file = rand(000000, 999999).'_'.$folder_ext[0].'.'.$extension;
      $path = $img->move('storage/upload/'.$folder, $file);
      return 'storage/upload/'.$folder.'/'.$file;
    } catch (\Throwable $th) {
      throw new InvalidArgumentException($th->getMessage(), 500);
    }
  }

  function createFile($folder, $name, $content){
    if (!empty($content)) {
      $path = 'storage/docs/'.$folder;
      if (!file_exists($path)) {
        mkdir($path, 0755, true);
      }
      $file = fopen($path.'/'.$name.'.txt', 'w') or die("");
      fwrite($file, $content);
    }
  }

  function deleteFile($img){
    if(file_exists($img)){
      unlink($img);
    }
  }

  function activity($req){
    return Activity::create(array_merge([
      'id_admin' => auth()->user()->id
    ], $req));
  }


  function deleteFolder($folder){
    try {
      $path = storage_path('app/public/upload/'.$folder);
      $file = new Filesystem;
      $file->cleanDirectory($path);
      rmdir($path);
    } catch (\Throwable $th) {
      //throw $th;
    }
  }

  public function pushNotif($head, $contents, $extend="", $user=""){
    $headings = array(
      "en" => $head
    );
    $content = array(
      "en" => $contents
    );
    $fields = [
      'app_id' => '12b2d23e-304f-4f5e-87e5-8958e25972b7',
      'channel_for_external_user_ids' => 'push',
      'data' => [
        'foo' => 'bar'
      ],
      'contents' => $content,
      'headings' => $headings,
      'small_icon' => 'ic_stat_wan_flora',
    ];
    if (!empty($user)) {
      $fields = array_merge($fields, [
        'include_external_user_ids' => $user
      ]);
    } else {
      $fields = array_merge($fields, [
        'included_segments' => ['Subscribed Users']
      ]);
    }
 
    if ($extend) {
      $fields = array_merge($fields, $extend);
    }

    $fields = json_encode($fields);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://onesignal.com/api/v1/notifications');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
      'Content-Type: application/json; charset=utf-8',
      'Authorization: Basic MmJmYjEzMDItYWU0Yi00ZmFmLThiOTktNDJjYzFlN2UyMTNl'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
  }


}
