<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\CustomerRepository;

class CustomerController extends Controller
{
    public function __construct(
        private CustomerRepository $repository,
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Pelanggan',
            'collection' => $this->repository->get($req->all())
        ];
        return view('customer.index', $params);
    }
    
    function find($id){
        $find = $this->repository->findWithRelation($id);
    
        if (!$find) {
            return(abort(404));
        }
    
        $params = [
            'title' => 'Pelanggan',
            'item' => $find
        ];
        return view('customer.find', $params);
    }
  
}
